﻿/*
VERSION:	2.5
	2.5		Change:		zooming without a mouse-cursor now zooms toward the center of the displayed content,  instead of the far top-left corner
	2.4		Change: 	zooming uses animation when quikTween2 is present in the same scope.  (if absent,  then instant-zooming is used)
	2.3		Add:  applyZoomValue() to set a specific zoom value at a specific coordinate
	2.2		Add:  "onZoom" event now provides the new "scale" value.  (0, 50, 100, 200, etc...)
	2.1		Fixed:  initialZoomIndex is actually applied upon setup
	2.0		Fixed mis-named function call:  setZoom()  =>  setZoomIndex()
	2.0		(maybe) Fixed the draw-freeze glitch, by checking scroll values for NaN & then floor()-ing them

USAGE:
	#include "functions/addScrollPaneZoom.as"
	var zoomLevels = [25, 50, 100, 200, 400];
	addScrollPaneZoom( my_pane, 0, zoomLevels, 2 );
	
PROPERTIES:
	targetPane.zoomEnabled				Toggles whether or not zooming occurs
	targetPane.zoomIndex					Sets the zoom level  (if it's 2 steps below the lowest scale, it'll be set to only 1 step below it)

EVENTS:
	scrollWheel										Triggers when the scroll wheel is moved
	onZoom												Triggers when the content is scaled via zoom... Returns the new scaleIndex and scale
	
KNOWN ISSUES:
	If "scrollDrag" is on, scrolling while zoomed out will be jittery.  (minor issue)
	
DEPTHS USED by ScrollPanes:
	_this: -16383
	_child0: 1
	mask_mc: 10000
	border_mc: -16383
	vScroller: 1002
	hScroller: 1001
	mask_mc: 10000
	vSB: 1002
	hSB: 1001
	spContentHolder: 1
	boundingBox_mc: -16000
	depthChild0: -16383
*/
addScrollPaneZoom = function( targetPane, scrollHandlerDepth, zoomLevels, initialZoomIndex )
{
	var animSeconds = 0.3;
	// disable normal wheel-scroll behavior  &  add "scrollWheel" event
	var scrollHandler_mc = targetPane.createEmptyMovieClip("scrollHandler_mc", scrollHandlerDepth);
	scrollHandler_mc.onEnterFrame = function(){		scrollHandler_mc.lastPosition = targetPane.vPosition;		}// loop()
	scrollHandler_mc.onMouseWheel = function( delta ){
		targetPane.vPosition = targetPane.scrollHandler_mc.lastPosition;
		if( targetPane.mask_mc.hitTest(_root._xmouse, _root._ymouse) )
			targetPane.dispatchEvent({type:"scrollWheel", delta:delta});
		targetPane.scrollHandler_mc.lastPosition = targetPane.vPosition;
	}// onMouseWheel()
	Mouse.addListener( scrollHandler_mc );
	scrollHandler_mc.onUnload = function(){
		Mouse.removeListener( targetPane.scrollHandler_mc );
	}// onUnload()
	
	
	
	// ----------------------------------------------------------------------------------
	
	
	
	var zoom_obj = targetPane.zoom_obj = {};
	
	// PROPERTIES
	targetPane.getZoomIndex = function(){
		return zoom_obj.zoomIndex;
	};targetPane.setZoomIndex = function(newValue, doEvent){
		zoom_obj.zoomIndex = newValue;
		zoom_obj.applyZoom( doEvent );
	}// get / set "zoomIndex"
	targetPane.addProperty( "zoomIndex", targetPane.getZoomIndex, targetPane.setZoomIndex );
	
	
	
	// Zoom Effect
	/*	
	zoom_obj.applyZoom = function( doEvent )
	{
		if( targetPane.mask_mc.hitTest(_root._xmouse, _root._ymouse) )
		{// if:  mouse is hovering over content bounds
			// // where was the mouse on the old image
			var oldZoomPointX = targetPane.content._xmouse;
			var oldZoomPointY = targetPane.content._ymouse;
		}// if:  mouse is hovering over content bounds
		else
		{// if:  the mouse is not over the pane
			var oldZoomPointX = 0;
			var oldZoomPointY = 0;
		}// if:  the mouse is not over the pane
		// apply zoom
		var scale = zoom_obj.zoomLevels[zoom_obj.zoomIndex];
		// // prevent the content from zooming smaller than the viewable area
		var oldScale = targetPane.content._xscale;
		var oldWidth = targetPane.content._width;
		var oldHeight = targetPane.content._height;
		var newWidth = oldWidth * scale / oldScale;
		var newHeight = oldHeight * scale / oldScale;
		var newScaleW = scale;
		var newScaleH = scale;
		if( newWidth < targetPane.viewableColumns ){
			newScaleW = oldScale * targetPane.viewableColumns / oldWidth;
		}
		if( newHeight < targetPane.viewableRows ){
			newScaleH = oldScale * targetPane.viewableRows / oldHeight;
		}
		scale = Math.max(newScaleW, newScaleH);		// pick the larger one
		// select the closest or lower zoom level
		for(var z in zoom_obj.zoomLevels){
			if( zoom_obj.zoomLevels[z] <= scale ){
				zoom_obj.zoomIndex = z;
				break;
			}// if:  this zoomLevel matches or is one step below the current scale
		}// for each zoomLevel
		// apply new scale
		targetPane.content._xscale = targetPane.content._yscale = scale;
		// IMMEDIATELY update the scroll bar size  (to allow newly zoomed scroll range)  (invalidate() would do it later)
		targetPane.size();
		// adjust scroll position
		// // where would the old mouse's position be on the newly zoomed image
		var newZoomPointX = oldZoomPointX *(scale/100);
		var newZoomPointY = oldZoomPointY *(scale/100);
		// // offset that point to where the mouse is now
		newZoomPointX -= targetPane._xmouse;
		newZoomPointY -= targetPane._ymouse;
		// // scroll to that point
		if( !isNaN(newZoomPointX)  &&  !isNaN(newZoomPointX) ){
			targetPane.hPosition = Math.floor(newZoomPointX);
			targetPane.vPosition = Math.floor(newZoomPointY);
		}// if:  scroll points are valid
		
		// announce zoom
		if(doEvent != false){
			targetPane.dispatchEvent({type:"onZoom", target:zoom_obj, zoomIndex:zoom_obj.zoomIndex, scale:scale});
			targetPane.onZoom( scale, zoom_obj.zoomIndex );
		}
	}// applyZoom()
	*/
	
	
	
	zoom_obj.applyZoom = function( doEvent )
	{
		if( targetPane.mask_mc.hitTest(_root._xmouse, _root._ymouse) )
		{// if:  mouse is hovering over content bounds
			// // where was the mouse on the old image
			var oldZoomPointX = targetPane.content._xmouse;
			var oldZoomPointY = targetPane.content._ymouse;
			// apply zoom
			zoom_obj.applyZoomValue( zoom_obj.zoomIndex, oldZoomPointX, oldZoomPointY, targetPane._xmouse, targetPane._ymouse );
		}// if:  mouse is hovering over content bounds
		else
		{// if:  the mouse is not over the pane
			var halfWidth = Math.floor(targetPane.mask_mc._width / 2);
			var halfHeight = Math.floor(targetPane.mask_mc._height / 2);
			var p1 = new flash.geom.Point( halfWidth, halfHeight );
			targetPane.localToGlobal( p1 );
			targetPane.content.globalToLocal( p1 );
			var oldZoomPointX = p1.x;
			var oldZoomPointY = p1.y;
			zoom_obj.applyZoomValue( zoom_obj.zoomIndex, oldZoomPointX, oldZoomPointY, halfWidth, halfHeight );
		}// if:  the mouse is not over the pane
		
		
		// announce zoom
		if(doEvent != false){
			var scale = zoom_obj.zoomLevels[zoom_obj.zoomIndex];
			targetPane.dispatchEvent({type:"onZoom", target:targetPane, zoomIndex:zoom_obj.zoomIndex, scale:scale});
			targetPane.onZoom( scale, zoom_obj.zoomIndex );
		}
	}// applyZoom()
	
	
	
	zoom_obj.applyZoomValue = function( zoomIndex, oldZoomPointX, oldZoomPointY, paneX, paneY ){
		if( paneX === undefined )		var paneX = Math.floor(targetPane.mask_mc._width / 2);
		if( paneY === undefined )		var paneY = Math.floor(targetPane.mask_mc._height / 2);
		zoom_obj.zoomIndex = zoomIndex;
		var scale = zoom_obj.zoomLevels[zoom_obj.zoomIndex];
		// // prevent the content from zooming smaller than the viewable area
		var oldScale = targetPane.content._xscale;
		var oldWidth = targetPane.content._width;
		var oldHeight = targetPane.content._height;
		var newWidth = oldWidth * scale / oldScale;
		var newHeight = oldHeight * scale / oldScale;
		var newScaleW = scale;
		var newScaleH = scale;
		if( newWidth < targetPane.viewableColumns ){
			newScaleW = oldScale * targetPane.viewableColumns / oldWidth;
		}
		if( newHeight < targetPane.viewableRows ){
			newScaleH = oldScale * targetPane.viewableRows / oldHeight;
		}
		scale = Math.max(newScaleW, newScaleH);		// pick the larger one
		// select the closest or lower zoom level
		for(var z in zoom_obj.zoomLevels){
			if( zoom_obj.zoomLevels[z] <= scale ){
				zoom_obj.zoomIndex = z;
				break;
			}// if:  this zoomLevel matches or is one step below the current scale
		}// for each zoomLevel
		
		
		// if:  quikTween2 is available  =>  animate
		if( quikTween2 ){
			zoom_obj.scaleAnim.abort();		// cancel previous animation
			var oldScale = targetPane.content._xscale;
			zoom_obj.scaleAnim = quikTween2( oldScale, scale, animSeconds, easeOut );
			zoom_obj.scaleAnim.onProgress = function( value ){
				targetPane.content._xscale = targetPane.content._yscale = value;
				// IMMEDIATELY update the scroll bar size  (to allow newly zoomed scroll range)  (invalidate() would do it later)
				targetPane.size();
			}// scaleAnim.onProgress()
			
			// adjust scroll position
			// // where would the old mouse's position be on the newly zoomed image
			var newZoomPointX = oldZoomPointX *(scale/100);
			var newZoomPointY = oldZoomPointY *(scale/100);
			// // offset that point to where the mouse is now
			// newZoomPointX -= targetPane._xmouse;
			// newZoomPointY -= targetPane._ymouse;
			newZoomPointX -= paneX;
			newZoomPointY -= paneY;
			
			zoom_obj.panXanim.abort();		// cancel previous animation
			zoom_obj.panXanim = quikTween2( targetPane.hPosition, newZoomPointX, animSeconds, easeOut );
			zoom_obj.panXanim.onProgress = function( value ){
				if( isNaN(value) )		return;
				// // scroll to that point
				targetPane.hPosition = Math.floor(value);
			}// panXanim.onProgress()
			
			zoom_obj.panYanim.abort();		// cancel previous animation
			zoom_obj.panYanim = quikTween2( targetPane.vPosition, newZoomPointY, animSeconds, easeOut );
			zoom_obj.panYanim.onProgress = function( value ){
				if( isNaN(value) )		return;
				// // scroll to that point
				targetPane.vPosition = Math.floor(value);
			}// panYanim.onProgress()
		}
		
		// else:  instant-change
		else{
			// apply new scale
			targetPane.content._xscale = targetPane.content._yscale = scale;
			// IMMEDIATELY update the scroll bar size  (to allow newly zoomed scroll range)  (invalidate() would do it later)
			targetPane.size();
			// adjust scroll position
			// // where would the old mouse's position be on the newly zoomed image
			var newZoomPointX = oldZoomPointX *(scale/100);
			var newZoomPointY = oldZoomPointY *(scale/100);
			// // offset that point to where the mouse is now
			// newZoomPointX -= targetPane._xmouse;
			// newZoomPointY -= targetPane._ymouse;
			newZoomPointX -= paneX;
			newZoomPointY -= paneY;
			// // scroll to that point
			if( !isNaN(newZoomPointX)	)		targetPane.hPosition = Math.floor(newZoomPointX);
			if( !isNaN(newZoomPointY) )		targetPane.vPosition = Math.floor(newZoomPointY);
		}// if:   quickTween2 is NOT available
		
	}// applyNewZoom()
	
	
	
	zoom_obj.scrollWheel = function( evt )
	{
		if(targetPane.zoomEnabled)
		{// if:  zoom is enabled
			if( targetPane.mask_mc.hitTest(_root._xmouse, _root._ymouse) )
			{// if:  mouse is hovering over content bounds
				if( evt.delta>0 )
				{// if:  wheel up
					if(zoom_obj.zoomIndex<zoom_obj.zoomLevels.length-1)
						zoom_obj.zoomIndex++;
				}// if:  wheel up
				else
				{// if:  wheel down
					if(zoom_obj.zoomIndex>0)
						zoom_obj.zoomIndex--;
				}// if:  wheel down
				zoom_obj.applyZoom( true );
			}// if:  mouse is hovering over content bounds
		}// if:  zoom is enabled
	}// scrollWheel()
	
	
	// zoom settings
	targetPane.zoomEnabled = true;
	zoom_obj.zoomLevels = zoomLevels;
	targetPane.setZoomIndex( initialZoomIndex, false );
	
	
	
	// clean-up
	zoom_obj.unload = function()
	{
		targetPane.removeEventListener("scrollWheel", zoom_obj);
		targetPane.removeEventListener("unload", zoom_obj);
	}
	targetPane.addEventListener("scrollWheel", zoom_obj);
	targetPane.addEventListener("unload", zoom_obj);
}// addScrollPaneZoom()